<?php
header("Content-Type: application/json");
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once "../config/db.php";

$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';

if ($username === '' || $password === '') {
    echo json_encode([
        "status" => "failed",
        "message" => "Username dan password wajib diisi"
    ]);
    exit;
}

$stmt = $conn->prepare(
    "SELECT id, name, username, role, password_hash
     FROM users
     WHERE username = ?
     LIMIT 1"
);

$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();

if (!$user) {
    echo json_encode([
        "status" => "failed",
        "message" => "User tidak ditemukan"
    ]);
    exit;
}

if (!password_verify($password, $user['password_hash'])) {
    echo json_encode([
        "status" => "failed",
        "message" => "Password tidak cocok"
    ]);
    exit;
}

unset($user['password_hash']);
echo json_encode([
    "status" => "success",
    "user" => $user
]);